/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.model;

import java.util.StringTokenizer;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.displaytag.decorator.TableDecorator;
import org.displaytag.exception.DecoratorException;
import org.displaytag.exception.ObjectLookupException;
import org.displaytag.model.Cell;
import org.displaytag.model.HeaderCell;
import org.displaytag.model.Row;
import org.displaytag.util.Anchor;
import org.displaytag.util.Href;
import org.displaytag.util.HtmlAttributeMap;
import org.displaytag.util.HtmlTagUtil;
import org.displaytag.util.LinkUtil;
import org.displaytag.util.LookupUtil;

public class Column {
    private Row row;
    private HeaderCell header;
    private HtmlAttributeMap htmlAttributes;
    private String stringValue;
    private Cell cell;

    public Column(HeaderCell headerCell, Cell currentCell, Row parentRow) {
        this.header = headerCell;
        this.row = parentRow;
        this.cell = currentCell;
        this.htmlAttributes = headerCell.getHtmlAttributes();
    }

    public Object getValue(boolean decorated) throws ObjectLookupException, DecoratorException {
        if (this.cell.getStaticValue() != null) {
            return this.cell.getStaticValue();
        }
        Object object = null;
        TableDecorator tableDecorator = this.row.getParentTable().getTableDecorator();
        object = decorated && tableDecorator != null && tableDecorator.hasGetterFor(this.header.getBeanPropertyName()) ? LookupUtil.getBeanProperty(tableDecorator, this.header.getBeanPropertyName()) : LookupUtil.getBeanProperty(this.row.getObject(), this.header.getBeanPropertyName());
        if (decorated && this.header.getColumnDecorator() != null) {
            object = this.header.getColumnDecorator().decorate(object);
        }
        if ((object == null || object.equals("null")) && !this.header.getShowNulls()) {
            object = "";
        }
        return object;
    }

    public String getOpenTag() throws ObjectLookupException, DecoratorException {
        this.stringValue = this.createChoppedAndLinkedValue();
        return HtmlTagUtil.createOpenTagString("td", this.htmlAttributes);
    }

    public String getCloseTag() {
        this.stringValue = null;
        return this.header.getCloseTag();
    }

    public String createChoppedAndLinkedValue() throws ObjectLookupException, DecoratorException {
        Object choppedValue = this.getValue(true);
        boolean isChopped = false;
        String fullValue = "";
        if (choppedValue != null) {
            fullValue = choppedValue.toString();
        }
        if (this.header.getMaxLength() > 0 && fullValue.length() > this.header.getMaxLength()) {
            choppedValue = fullValue.substring(0, this.header.getMaxLength()) + "...";
            isChopped = true;
        } else if (this.header.getMaxWords() > 0) {
            StringBuffer buffer = new StringBuffer();
            StringTokenizer tokenizer = new StringTokenizer(fullValue);
            int tokensNum = tokenizer.countTokens();
            if (tokensNum > this.header.getMaxWords()) {
                int wordsCount = 0;
                while (tokenizer.hasMoreTokens() && wordsCount < this.header.getMaxWords()) {
                    buffer.append(tokenizer.nextToken() + " ");
                    ++wordsCount;
                }
                buffer.append("...");
                choppedValue = buffer;
                isChopped = true;
            }
        }
        if (isChopped) {
            this.htmlAttributes = (HtmlAttributeMap)this.htmlAttributes.clone();
            this.htmlAttributes.put("title", fullValue);
        }
        if (this.header.getAutoLink()) {
            choppedValue = LinkUtil.autoLink(choppedValue.toString());
        } else if (this.header.getHref() != null) {
            Href colHref = new Href(this.header.getHref());
            if (this.header.getParamName() != null) {
                Object paramValue = this.header.getParamProperty() != null ? LookupUtil.getBeanProperty(this.row.getObject(), this.header.getParamProperty()) : fullValue;
                colHref.addParameter(this.header.getParamName(), paramValue);
            }
            Anchor anchor = new Anchor(colHref, choppedValue.toString());
            choppedValue = anchor.toString();
        }
        if (choppedValue != null) {
            return choppedValue.toString();
        }
        return null;
    }

    public String getChoppedAndLinkedValue() {
        return this.stringValue;
    }

    public int getGroup() {
        return this.header.getGroup();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SIMPLE_STYLE).append("cell", (Object)this.cell).append("header", (Object)this.header).append("htmlAttributes", (Object)this.htmlAttributes).append("stringValue", (Object)this.stringValue).toString();
    }
}

